import java.util.Arrays;

public class ArrayExperiments {

    public static Double[] initialize(int size) {
        // An array of random doubles
        Double[] d = new Double[size];
        for (int i = 0; i < size; i++) {
            d[i] = StdRandom.uniform();
        }
        return d;
    }

    public static long retrieve_by_index(Double[] d) {
        int i = (int) (StdRandom.uniform() * d.length);
        long startTime = System.nanoTime();
        Double r = d[i];
        return (System.nanoTime() - startTime);
    }

    public static long retrieve_by_element(Double[] d) {
        Double r = d[(int) (StdRandom.uniform() * d.length)];
        long startTime = System.nanoTime();
        // TODO Find element r in Array d using a binary search
        return (System.nanoTime() - startTime);
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        long trials = Long.parseLong(args[1]);

        Double[] d = initialize(size);

        System.out.println("Timing retrieval by index...");
        long index_retrieval = 0;
        for (long t = 0; t < trials; t++) {
            index_retrieval += retrieve_by_index(d);
        }
        System.out.println(
                "Retrieval by index: " + (index_retrieval / ((double) trials))
                        + " nanoseconds on average");

        System.out.println("Sorting array...");
        Arrays.sort(d);

        System.out.println("Timing retrieval by element...");
        long element_retrieval = 0;
        for (long t = 0; t < trials; t++) {
            element_retrieval += retrieve_by_element(d);
        }
        System.out.println(
                "Retrieval by element: " + element_retrieval / ((double) trials)
                        + " nanoseconds on average");

    }
}
